/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.registry.BlockEntityRegistry;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.entity.BottleGourdBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BottleGourd
extends DecorativeBlock
implements EntityBlock {
    public static final VoxelShape GOURD = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);

    public BottleGourd(DecorativeBlock.Builder builder) {
        super(builder);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack item = pPlayer.m_21120_(pHand);
        Optional optionalBlockEntity = pLevel.m_141902_(pPos, (BlockEntityType)BlockEntityRegistry.BOTTLE_GOURD.get());
        if (!optionalBlockEntity.isPresent()) {
            return InteractionResult.PASS;
        }
        BottleGourdBlockEntity blockEntity = (BottleGourdBlockEntity)((Object)optionalBlockEntity.get());
        if (item.m_150930_(Items.f_42589_)) {
            Potion potion = PotionUtils.m_43579_((ItemStack)item);
            if (blockEntity.addPotionCharge(potion)) {
                if (!pLevel.m_5776_() && !pPlayer.m_150110_().f_35937_) {
                    item.m_41774_(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)new ItemStack((ItemLike)Items.f_42590_));
                }
                pLevel.m_5594_(null, pPos, SoundEvents.f_11772_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
        } else if (blockEntity.hasCharges()) {
            Optional<Potion> potion1 = blockEntity.takePotionCharge();
            if (potion1.isPresent()) {
                if (!pLevel.m_5776_()) {
                    for (MobEffectInstance effectInstance : potion1.get().m_43488_()) {
                        if (effectInstance.m_19544_().m_8093_()) {
                            effectInstance.m_19544_().m_19461_((Entity)pPlayer, (Entity)pPlayer, (LivingEntity)pPlayer, effectInstance.m_19564_(), 1.0);
                            continue;
                        }
                        pPlayer.m_7292_(new MobEffectInstance(effectInstance));
                    }
                }
                pLevel.m_6269_(null, (Entity)pPlayer, SoundEvents.f_11911_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        pLevel.m_141902_(pPos, (BlockEntityType)BlockEntityRegistry.BOTTLE_GOURD.get()).ifPresent(entity -> {
            if (entity.hasCharges() && !pLevel.m_5776_()) {
                int charges = entity.getCharges();
                List effects = entity.getPotion().m_43488_();
                if (!effects.isEmpty()) {
                    AreaEffectCloud areaeffectcloud = new AreaEffectCloud(pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_());
                    areaeffectcloud.m_19712_(0.5f * (float)charges);
                    areaeffectcloud.m_19732_(-0.5f);
                    areaeffectcloud.m_19740_(10);
                    areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() * charges / 2);
                    areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
                    for (MobEffectInstance mobeffectinstance : effects) {
                        areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
                    }
                    pLevel.m_7967_((Entity)areaeffectcloud);
                }
            }
        });
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BottleGourdBlockEntity(pPos, pState);
    }
}

